//				file	VBto_Converter.cpp
// This is a part of the VBto Converter (www.vbto.net). Copyright (C) 2005-2009 StressSoft Company Ltd. All rights reserved.
//

#include "stdafx.h"

#include "VBto_Converter.h"

CString GetWindowText(const CWnd *wnd) {
	CString cs;
	wnd->GetWindowText(cs);
	return cs;
}

CString LCase(const CString &csI) {
	CString cs = csI;
	cs.MakeLower();
	return cs;
}

CString Format(const char *fmt, ...) {
	va_list params;
	va_start(params, fmt);
	CString cs;
	cs.FormatV(fmt,params);
	va_end(params);
	return cs;
}


CString GetFmt(const char * vbfmt, const char * cfmt) {
	if (!vbfmt) return CString("%") + cfmt;
	int nPos=0;
	bool flIs0=false;
	bool flIsDot=false;
	CString fmt="%", fmt0, fmt1, sPos;
	for(const char *p=vbfmt; *p; p++) {
		switch(*p) {
			case '-':	case '+':	case '$':	case '(':	case ')':
			case ' ':	case '\t':	case '\r':	case '\n':
				if (flIsDot)	fmt1 += *p;
				else			fmt0 += *p;
				break;
			case '0':
				if (!nPos) flIs0 = true;
			case '#':
				nPos++;
				break;
			case '.':
				flIsDot = true;
				if (flIs0) fmt += "0";
				if (nPos) {
					sPos.Format("%d",nPos);
					fmt += sPos;
				}
				nPos = 0;
				flIs0 = false;
				break;
		}
	}

	if (nPos) {
		if (flIsDot) fmt += ".";
		if (flIs0) fmt += "0";
		sPos.Format("%d",nPos);
		fmt += sPos + CString(cfmt);
	} else {
		fmt += CString(cfmt);
		if (flIsDot) fmt += ".";
	}

	return fmt0 + fmt + fmt1;
}
CString FormatVB(short val, const char *vbfmt) {
	CString fmt = GetFmt(vbfmt,"hd");
	CString ret;
	ret.Format(fmt, val);
	return ret;
}
CString FormatVB(int val, const char *vbfmt) {
	CString fmt = GetFmt(vbfmt,"d");
	CString ret;
	ret.Format(fmt, val);
	return ret;
}
CString FormatVB(long val, const char *vbfmt) {
	CString fmt = GetFmt(vbfmt,"ld");
	CString ret;
	ret.Format(fmt, val);
	return ret;
}
CString FormatVB(float val, const char *vbfmt) {
	CString fmt = GetFmt(vbfmt,"g");
	CString ret;
	ret.Format(fmt, val);
	return ret;
}
CString FormatVB(double val, const char *vbfmt) {
	CString fmt = GetFmt(vbfmt,"lf");
	CString ret;
	ret.Format(fmt, val);
	return ret;
}
CString FormatVB(const char *str, const char *vbfmt) {
	return str;
}
CString FormatVB(const CString &cs, const char *vbfmt) {
	return cs;
}


CString Str(short val) {
	CString cs = Format("%hd", val);
	return val>=0 ? (' '+cs) : cs;
}
CString Str(int val) {
	CString cs = Format("%d", val);
	return val>=0 ? (' '+cs) : cs;
}
CString Str(unsigned int val) {
	CString cs = Format("%u", val);
	return val>=0 ? (' '+cs) : cs;
}
CString Str(float val) {
	CString cs = Format("%g", val);
	return val>=0 ? (' '+cs) : cs;
}
CString Str(double val) {
	CString cs = Format("%lg", val);
	return val>=0 ? (' '+cs) : cs;
}
CString Str(bool val) {
	return val ? " True" : " False";
}
CString Str(const CComVariant &val) {
	CComVariant ret = val;
	ret.ChangeType(VT_BSTR);
	CComBSTR cc = ret.bstrVal;
	return CString(cc.m_str);
}

double CDbl(const CString &s) {
	const char *pBuf = (const char *) s;
	double ret = 0;
	sscanf(pBuf,"%lg",&ret);
	return ret;
}

double Round(double d) {
	return (int)(d>=0 ? (d+0.5) : (d-0.5));
}

void DoEvents(HWND hWndEvents) {
	MSG msg;
	while (PeekMessage(&msg, hWndEvents, 0, 0, PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
}

void PrintLine(HANDLE hf, const CString &cs) {
	DWORD dwSize;
	::WriteFile(hf, cs, cs.GetLength(), &dwSize, NULL);
	::WriteFile(hf, "\r\n", 2, &dwSize, NULL);
}
void Print(HANDLE hf, const CString &cs) {
	DWORD dwSize;
	::WriteFile(hf, cs, cs.GetLength(), &dwSize, NULL);
}

 int CurrentX, CurrentY;

void DrawString(CWnd *wnd, const CString &Str, float x, float y) {
	CDC *cdc = wnd->GetDC();
	cdc->TextOut((int)x,(int)y,Str);
	wnd->ReleaseDC(cdc);
}
void DrawString(CWnd *wnd, const CString &Str) {
	DrawString(wnd, Str, float(CurrentX), float(CurrentY));
	CurrentX = 0;
	LOGFONT lf;
	wnd->GetFont()->GetLogFont(&lf);
	int lfHeight = lf.lfHeight;
	if (lfHeight<0) lfHeight = -lfHeight;
	CurrentY += lfHeight + 3;
}

